﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=unicode" />
	<title>Zestawienie księgowe RB 28</title>

	

	<script runat="server">
		
	
		private void DataContext_Load(Object sender, EventArgs args)
		{
			OkresObrachunkowy o = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
		    WynikZestKS w = null;
            if (DataContext1.Context.Contains(typeof (WynikZestKS)))
            {
                w = (WynikZestKS) DataContext1.Get(typeof (WynikZestKS));
            }
            ZestawienieKS z;
            if (w != null)
                z = w.Zestawienie;
            else
                z = (ZestawienieKS) DataContext1.Get(typeof (ZestawienieKS));
            ZestawieniaKS.Params p = new ZestawieniaKS.Params(DataContext1.Context);
            if (DataContext1.Context.Contains(typeof (ZestawieniaKS.Params)))
                p = (ZestawieniaKS.Params) DataContext1.Get(typeof (ZestawieniaKS.Params));

			//if (z.Guid != ZestawienieKS.Budzetowka_RB28)
				//throw new ApplicationException("Wydruk przystosowany jest wyłącznie do standardowego zestawienia RB28.");
			
			ZestawienieKS.Wynik wynik = z.ObliczZestawienie(o, p);
			GridRb28.DataSource = wynik.Pozycje;
		}


		private void OnBeforeRow(Object sender, RowEventArgs args)
		{
			ZestawienieKS.Pozycja poz = (ZestawienieKS.Pozycja)args.Row;

			int indexFst = poz.Opis.IndexOf(KontoBase.Separator);
			int indexLst = poz.Opis.LastIndexOf(KontoBase.Separator);

			if (indexFst == indexLst)
			{
				IdRozdzial.EditValue = "?";
				IdParagraf.EditValue = "?";
			}
			else
			{
				IdRozdzial.EditValue = poz.Opis.Substring(indexFst + 1, indexLst - indexFst - 1);
				IdParagraf.EditValue = poz.Opis.Substring(indexLst + 1);
			}
		}

	
	</script>
</head>
<body>
	<form id="ZestawienieKsiegowe" method="post" runat="server">
	<ea:DataContext ID="DataContext1" runat="server" OnContextLoad="DataContext_Load"  Landscape="true"/>

	<div style="text-align:right;font-family:Tahoma;font-size:10px;">Załącznik nr 13</div>
	<table border="1" width="100%" cellpadding="1" cellspacing="0" style="border-collapse:collapse;font-family:Tahoma;font-size:9px;text-align:center;">
		<tr>
			<td colspan="10" style="text-align:left;">Ministerstwo Finansów, ul. Świętokrzyska 12, 00-916 Warszawa</td>
		</tr>
		<tr style="height:2cm;">
			<td colspan="4" style="text-align:left; vertical-align:top;">Nazwa i adres jednostki sprawozdzawczej</td>
			<td colspan="4" rowspan="6" style="font-size:12px; font-weight:bold;">
				<p>Rb-28 miesięczne / roczne<sup>1)</sup><br />sprawozdanie z wykonania planu wydatków<br />budżetu państwa</p>
				<p>za okres od początku roku<br />do dnia ....................... 20... roku</p>
			</td>
			<td colspan="2" rowspan="4" style="text-align:left; vertical-align:top;">Adresat</td>
		</tr>
		<tr>
			<td colspan="4" style="height:1.2cm; text-align:left; vertical-align:top;">Numer identyfikacyjny REGON</td>
		</tr>
		<tr>
			<td colspan="4">Symbole</td>
		</tr>
		<tr>
			<td colspan="2">części / woj</td>
			<td>jedn.</td>
			<td>&nbsp;</td>
		</tr>
		<tr>
			<td>1</td>
			<td>2</td>
			<td>3</td>
			<td>4</td>
			<td colspan="2" style="text-align:left;">Wysłać bez pisma przewodniego</td>
		</tr>
		<tr style="height:0.6cm;">
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<td colspan="2" style="text-align:left; vertical-align:top;">Przed wypełnieniem przeczytać instrukcję</td>
		</tr>
		<tr>
			<td colspan="3">Klasyfikacja budżetowa</td>
			<td rowspan="4">Plan (po zmianach)</td>
			<td rowspan="4">Zaangażowanie</td>
			<td rowspan="4">Wykonanie wydatków</td>
			<td colspan="3">Zobowiązania według stanu na koniec okr. sprawozdawczego</td>
			<td rowspan="4">Wydatki, które nie wygasły z upływem bieżącego roku budżetowego <sup>2)</sup></td>
		</tr>
		<tr>
			<td rowspan="3">dział</td>
			<td rowspan="3">rozdział</td>
			<td rowspan="3">paragraf</td>
			<td rowspan="3">ogółem</td>
			<td colspan="2">w tym:</td>
		</tr>
		<tr>
			<td rowspan="2">wymagalne</td>
			<td>w tym:</td>
		</tr>
		<tr>
			<td>wobec u.s z tytułu potrąceń</td>
		</tr>
		<tr>
			<td style="width:69px;">5</td>
			<td style="width:69px;">6</td>
			<td style="width:69px;">7</td>
			<td style="width:105px;">8</td>
			<td style="width:105px;">9</td>
			<td style="width:105px;">10</td>
			<td style="width:105px;">11</td>
			<td style="width:105px;">12</td>
			<td style="width:105px;">13</td>
			<td>14</td>
		</tr>
	</table>

	<ea:Grid ID="GridRb28" runat="server" ShowHeader="None" OnBeforeRow="OnBeforeRow" >
		<Columns>
			<ea:GridColumn runat="server" Width="12" DataMember="Numer" />
			<ea:GridColumn runat="server" Width="12" ID="IdRozdzial" />
			<ea:GridColumn runat="server" Width="12" ID="IdParagraf" />
			<ea:GridColumn runat="server" Width="18" Align="Right" Format="{0:n}" DataMember="Plan" />
			<ea:GridColumn runat="server" Width="18" Align="Right" Format="{0:n}" DataMember="Zaangażowanie" />
			<ea:GridColumn runat="server" Width="18" Align="Right" Format="{0:n}" DataMember="Wykonanie wydatków" />
			<ea:GridColumn runat="server" Width="18" Align="Right" Format="{0:n}" DataMember="Zobowiązania ogółem" />
			<ea:GridColumn runat="server" Width="18" Align="Right" Format="{0:n}" DataMember="w tym wymagalne" />
			<ea:GridColumn runat="server" Width="18" Align="Right" Format="{0:n}" DataMember="w tym wobec US"/>
			<ea:GridColumn runat="server" Align="Right" Format="{0:n}" DataMember="Wydatki które nie wygasły" />
		</Columns>
	</ea:Grid>

	<div style="font-family:Tahoma;font-size:8px;margin-bottom:10px;">
		1) niepotrzebne skreślić<br />
		2) wypełnia się tylko w sprawozdaniu miesięcznym za grudzień i w sprawozdaniu rocznym
	</div>

	<cc1:ReportFooter ID="ReportFooter1" runat="server">
		<Subtitles>
			<cc1:FooterSubtitle runat="server"  SubtitleType="Text" Caption="Główny księgowy" />
			<cc1:FooterSubtitle runat="server"  SubtitleType="Text" Caption="rok m-c dzień" />
			<cc1:FooterSubtitle runat="server"  SubtitleType="Text" Caption="Kierownik jednostki" />
		</Subtitles>
	</cc1:ReportFooter>
	</form>
</body>
</html>

